/* FILE: mbase36.h                              (D. Tottingham  07/28/89)

This is an include file of the defines, data structure definitions and
external data declarations for base 36 number manipulation.

*/

#ifndef _MBASE36_
#define _MBASE36_

/************************************************************************
                               INCLUDES

************************************************************************/
#include "mconst.h"


/************************************************************************
                        STRUCTURE DEFINITIONS

The following structure definitions are included in mbase36.h, so that all
modules can have access to them.

************************************************************************/
typedef struct {
        int     high;
        int     low;
} B_BASE36;


/************************************************************************
                            EXTERNAL DATA

The following external data can be accessed by any module that includes
this file.

************************************************************************/
PUBLIC char * base36_num[];               /* base36 conversion array */



/************************************************************************
                         EXTERNAL DECLARATIONS

These functions can be called from all modules that include this file.

************************************************************************/
PUBLIC unsigned int b_convert_base10 (B_BASE36);
PUBLIC void b_init_base36 (B_BASE36 *);
PUBLIC void b_incr_base36 (B_BASE36 *);

#endif
